/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: PGPsdkDriverAPI.c,v 1.6 2000/10/13 01:35:23 pbj Exp $
____________________________________________________________________________*/
#include "pgpPFLErrors.h"
#include "pgpConfig.h"
#include "pgpRandomContext.h"
#include "pgpRnd.h"
#include "pgpMemoryMgr.h"
#include "pgpMem.h"
#include "pgpErrors.h"

#include <windows.h>
#include <winperf.h>   // for Windows NT
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tlhelp32.h>  // for Windows 95
#include "pgpSDKBuildFlags.h"
#include "PGPsdkDriver.h"

static HANDLE 		hPGPUtilDriver			= INVALID_HANDLE_VALUE;
static PGPBoolean	bEntropyDriverInstalled	= FALSE;

PGPBoolean
pgpSDKDriverIsInstalled()
{
	if (hPGPUtilDriver != INVALID_HANDLE_VALUE)
		return TRUE;
	else
		return FALSE;
}

PGPBoolean
pgpSDKEntropyDriverIsRunning()
{
	return bEntropyDriverInstalled;
}

PGPBoolean
pgpSDKKeyboardEntropyDriverIsWorking()
{
	static PGPBoolean	bChecked		= FALSE;
	static PGPBoolean	bWorking		= FALSE;
	INT					iBufferLen		= 0;

	PGPGENERICSTRUCT	pgs;
	DWORD				dwReturned;

	if (!bChecked)
	{
		bChecked = TRUE;

		if (bEntropyDriverInstalled)
		{
			if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_GENERIC, 
					&pgs, iBufferLen, &pgs, iBufferLen, &dwReturned, NULL)) 
			{
				if (pgs.ulError == kPGPUDError_NoErr) 
				{
					if (pgs.ulFlags & kPGPUDFlag_KeyboardHookCalled)
						bWorking = TRUE;
				}
			}
		}
	}

	return bWorking;
}

PGPBoolean
pgpSDKMouseEntropyDriverIsWorking()
{
	static PGPBoolean	bChecked		= FALSE;
	static PGPBoolean	bWorking		= FALSE;
	INT					iBufferLen		= 0;

	PGPGENERICSTRUCT	pgs;
	DWORD				dwReturned;

	if (!bChecked)
	{
		bChecked = TRUE;

		if (bEntropyDriverInstalled)
		{
			if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_GENERIC, 
					&pgs, iBufferLen, &pgs, iBufferLen, &dwReturned, NULL)) 
			{
				if (pgs.ulError == kPGPUDError_NoErr) 
				{
					if (pgs.ulFlags & kPGPUDFlag_MouseHookCalled)
						bWorking = TRUE;
				}
			}
		}
	}

	return bWorking;
}

PGPError
pgpSDKInitDriver()
{
	PGPGENERICSTRUCT	pgs;
	DWORD				dwReturned;
	OSVERSIONINFO		osid;
	BOOL				bIsWinNT;
	INT					iBufferLen		= 0;

	osid.dwOSVersionInfoSize = sizeof(osid);
	GetVersionEx(&osid);   
	bIsWinNT = (osid.dwPlatformId == VER_PLATFORM_WIN32_NT);

	if (bIsWinNT)
	{
		hPGPUtilDriver = CreateFile ("\\\\.\\PGPsdkDriver", 
			0, 0, NULL, OPEN_EXISTING, 0, NULL);
	}
	else
	{
		hPGPUtilDriver = CreateFile ("\\\\.\\PGPsdk.vxd", 
			0, 0, NULL, 0, 0, NULL);
	}

	if (hPGPUtilDriver == INVALID_HANDLE_VALUE)
		return kPGPError_CantOpenFile;

	iBufferLen = sizeof(pgs);
	pgs.ulOperation = kPGPUDOperation_QueryStatus;

	if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_GENERIC, 
			&pgs, iBufferLen, &pgs, iBufferLen, &dwReturned, NULL)) {

		if (pgs.ulError == kPGPUDError_NoErr) {
			if ((pgs.ulFlags & kPGPUDFlag_KeyboardHookInstalled) &&
				(pgs.ulFlags & kPGPUDFlag_MouseHookInstalled))
			{
				bEntropyDriverInstalled = TRUE;
			}
			return kPGPError_NoErr;
		}
		else
			return kPGPError_CantOpenFile;
	}
	else {
		CloseHandle(hPGPUtilDriver);
		hPGPUtilDriver = INVALID_HANDLE_VALUE;
		return kPGPError_CantOpenFile;
	}

	return kPGPError_NoErr;
}

PGPUInt32
pgpDriverRandomPoolGetEntropy()
{
	PGPENTROPYSTRUCT ppes;
	int iBufferLen;
	DWORD dwReturned;

	if (hPGPUtilDriver == INVALID_HANDLE_VALUE)
		return 0;

	iBufferLen = sizeof(PGPENTROPYSTRUCT);
	ppes.ulOperation = kPGPUDOperation_QueryEntropy;
	ppes.ulBufferLength = sizeof(ULONG);

	if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_ENTROPY, 
		&ppes, iBufferLen, &ppes, iBufferLen, &dwReturned, NULL)) {	
		return ppes.ulEntropyBits;
	}

	return 0;
}

PGPError
pgpDriverRandomPoolGetBytesEntropy(void *buf, PGPSize len)
{
	PGPENTROPYSTRUCT *ppes;
	PGPMemoryMgrRef memref;
	INT iBufferLen;
	DWORD dwReturned;
	PGPError err;

	memref = PGPGetDefaultMemoryMgr();
	if (memref == kInvalidPGPMemoryMgrRef)
		return kPGPError_UnknownError;

	if (hPGPUtilDriver == INVALID_HANDLE_VALUE)
		return kPGPError_LazyProgrammer;

	iBufferLen = sizeof(PGPENTROPYSTRUCT) + len;
	ppes = PGPNewData(memref, iBufferLen, kPGPMemoryMgrFlags_Clear);
	if (ppes == NULL)
		return kPGPError_OutOfMemory;

	ppes->ulOperation = kPGPUDOperation_GetEntropy;
	ppes->ulBufferLength = len;

	if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_ENTROPY, 
			ppes, iBufferLen, ppes, iBufferLen, &dwReturned, NULL)) {
		pgpCopyMemory(ppes->ucEntropyBuffer, buf, len);
		err = kPGPError_NoErr;
	}
	else
		err = kPGPError_LazyProgrammer;

	PGPFreeData(ppes);

	return err;
}
